/*****************************************************
définition des différentes grandeurs et initialisation
*****************************************************/

#define analogPin 0     // définition de la broche de mesure de uC
#define chargePin 8    // définition de la broche permettant la charge ou décharge du condensateur
#define DEL_Pin 7     // définition de la broche d’alimentation de la DEL

unsigned long Instantlnitial ; 
unsigned long Tau ;           // Tau = Temps Caractéristique en microsecondes (µs)
float C ;                     // C = Capacité en nanofarad (nF)
float Cseuil = **** ; // définition de la capacité seuil en-dessous de laquelle la DEL
                        // s’éteindra (remplacer **** par une valeur en nF)

void setup(){ 
  pinMode(chargePin,OUTPUT) ; 
  digitalWrite(chargePin,LOW) ;
  Serial.begin(9600) ;
  pinMode(DEL_Pin,OUTPUT) ;
  pinMode(DEL_Pin,LOW) ;
}

/**********************************
 Mesure et affichage de la capacité
**********************************/

void loop(){
  digitalWrite(chargePin,HIGH) ;
  Instantlnitial = micros() ;
  while(analogRead(analogPin) < 647) {
    } 
  Tau = micros() - Instantlnitial ; // calcul de tau
  C = (Tau*1000.0/1000000.0);       // calcul de la capacité en nanofarad (nF)
  Serial.print("C =") ;
  Serial.print(C) ;
  Serial.println(" nF") ;
  
/***************************
Commande de l'appareil (DEL)
***************************/
  
  if(C > Cseuil) {
  digitalWrite(DEL_Pin, HIGH) ;
  }
  else {
  digitalWrite(DEL_Pin, LOW) ;
  }
  digitalWrite(chargePin,LOW) ;
  while(analogRead(analogPin) > 0){
    }                           

/***********************
Pause entre deux mesures
***********************/
  
  delay(1000) ;    // le programme attend 1000 ms avant de poursuivre
}
